/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TextureUtils {
    public static final int WINDOW_TEXTURE_TYPE = 0;
    public static final int BACKGROUND_TEXTURE_TYPE = 1;
    public static final int ALTER_BACKGROUND_TEXTURE_TYPE = 2;
    public static final int SELECTED_TEXTURE_TYPE = 3;
    public static final int ROLLOVER_TEXTURE_TYPE = 4;
    public static final int PRESSED_TEXTURE_TYPE = 5;
    public static final int DISABLED_TEXTURE_TYPE = 6;
    public static final int MENUBAR_TEXTURE_TYPE = 7;
    public static final int LAST_TEXTURE_TYPE = 7;
    public static final String WINDOW_TEXTURE_KEY = "WindowTexture";
    public static final String BACKGROUND_TEXTURE_KEY = "BackgroundTexture";
    public static final String ALTER_BACKGROUND_TEXTURE_KEY = "AlterBackgroundTexture";
    public static final String SELECTED_TEXTURE_KEY = "SelectedTexture";
    public static final String ROLLOVER_TEXTURE_KEY = "RolloverTexture";
    public static final String PRESSED_TEXTURE_KEY = "PressedTexture";
    public static final String DISABLED_TEXTURE_KEY = "DisabledTexture";
    public static final String MENUBAR_TEXTURE_KEY = "MenubarTexture";
    private static Icon windowTexture = null;
    private static Icon backgroundTexture = null;
    private static Icon alterBackgroundTexture = null;
    private static Icon selectedTexture = null;
    private static Icon rolloverTexture = null;
    private static Icon pressedTexture = null;
    private static Icon disabledTexture = null;
    private static Icon menubarTexture = null;

    private TextureUtils() {
    }

    public static void setUpTextures() {
        String textureSet = "Default";
        if (AbstractLookAndFeel.getTheme() != null) {
            textureSet = AbstractLookAndFeel.getTheme().getTextureSet();
        }
        if (textureSet.startsWith("Rock")) {
            windowTexture = new LazyImageIcon("texture/patterns/rock/window_texture.jpg");
            backgroundTexture = new LazyImageIcon("texture/patterns/rock/background_texture.jpg");
            alterBackgroundTexture = new LazyImageIcon("texture/patterns/rock/alter_background_texture.jpg");
            selectedTexture = new LazyImageIcon("texture/patterns/rock/window_texture.jpg");
            rolloverTexture = new LazyImageIcon("texture/patterns/rock/rollover_texture.jpg");
            pressedTexture = new LazyImageIcon("texture/patterns/rock/pressed_texture.jpg");
            disabledTexture = new LazyImageIcon("texture/patterns/rock/background_texture.jpg");
            menubarTexture = new LazyImageIcon("texture/patterns/rock/menubar_texture.jpg");
        } else if (textureSet.startsWith("Textile")) {
            windowTexture = new LazyImageIcon("texture/patterns/textile/window_texture.jpg");
            backgroundTexture = new LazyImageIcon("texture/patterns/textile/background_texture.jpg");
            alterBackgroundTexture = new LazyImageIcon("texture/patterns/textile/alter_background_texture.jpg");
            selectedTexture = new LazyImageIcon("texture/patterns/textile/window_texture.jpg");
            rolloverTexture = new LazyImageIcon("texture/patterns/textile/rollover_texture.jpg");
            pressedTexture = new LazyImageIcon("texture/patterns/textile/rollover_texture.jpg");
            disabledTexture = new LazyImageIcon("texture/patterns/textile/background_texture.jpg");
            menubarTexture = new LazyImageIcon("texture/patterns/textile/menubar_texture.jpg");
        } else if (textureSet.startsWith("Snow")) {
            windowTexture = new LazyImageIcon("texture/patterns/snow/window_texture.jpg");
            backgroundTexture = new LazyImageIcon("texture/patterns/snow/background_texture.jpg");
            alterBackgroundTexture = new LazyImageIcon("texture/patterns/snow/alter_background_texture.jpg");
            selectedTexture = new LazyImageIcon("texture/patterns/snow/selected_texture.jpg");
            rolloverTexture = new LazyImageIcon("texture/patterns/snow/rollover_texture.jpg");
            pressedTexture = new LazyImageIcon("texture/patterns/snow/pressed_texture.jpg");
            disabledTexture = new LazyImageIcon("texture/patterns/snow/background_texture.jpg");
            menubarTexture = new LazyImageIcon("texture/patterns/snow/window_texture.jpg");
        } else {
            windowTexture = new LazyImageIcon("texture/patterns/leather/window_texture.jpg");
            backgroundTexture = new LazyImageIcon("texture/patterns/leather/background_texture.jpg");
            alterBackgroundTexture = new LazyImageIcon("texture/patterns/leather/alter_background_texture.jpg");
            selectedTexture = new LazyImageIcon("texture/patterns/leather/window_texture.jpg");
            rolloverTexture = new LazyImageIcon("texture/patterns/leather/rollover_texture.jpg");
            pressedTexture = new LazyImageIcon("texture/patterns/leather/pressed_texture.jpg");
            disabledTexture = new LazyImageIcon("texture/patterns/leather/background_texture.jpg");
            menubarTexture = new LazyImageIcon("texture/patterns/leather/menubar_texture.jpg");
        }
        Icon texture = AbstractLookAndFeel.getTheme().getWindowTexture();
        if (texture != null) {
            windowTexture = texture;
        }
        if ((texture = AbstractLookAndFeel.getTheme().getBackgroundTexture()) != null) {
            backgroundTexture = texture;
        }
        if ((texture = AbstractLookAndFeel.getTheme().getAlterBackgroundTexture()) != null) {
            alterBackgroundTexture = texture;
        }
        if ((texture = AbstractLookAndFeel.getTheme().getSelectedTexture()) != null) {
            selectedTexture = texture;
        }
        if ((texture = AbstractLookAndFeel.getTheme().getRolloverTexture()) != null) {
            rolloverTexture = texture;
        }
        if ((texture = AbstractLookAndFeel.getTheme().getPressedTexture()) != null) {
            pressedTexture = texture;
        }
        if ((texture = AbstractLookAndFeel.getTheme().getDisabledTexture()) != null) {
            disabledTexture = texture;
        }
        if ((texture = AbstractLookAndFeel.getTheme().getMenubarTexture()) != null) {
            menubarTexture = texture;
        }
    }

    public static int getTextureType(JComponent c2) {
        int bt;
        int textureType = 1;
        Object textureProperty = c2.getClientProperty("textureType");
        if (textureProperty instanceof Integer && (bt = ((Integer)textureProperty).intValue()) >= 0 && bt <= 7) {
            textureType = bt;
        }
        return textureType;
    }

    public static Icon getTexture(int textureType) {
        Icon texture = null;
        switch (textureType) {
            case 0: {
                texture = windowTexture;
                break;
            }
            case 1: {
                texture = backgroundTexture;
                break;
            }
            case 2: {
                texture = alterBackgroundTexture;
                break;
            }
            case 3: {
                texture = selectedTexture;
                break;
            }
            case 4: {
                texture = rolloverTexture;
                break;
            }
            case 5: {
                texture = pressedTexture;
                break;
            }
            case 6: {
                texture = disabledTexture;
                break;
            }
            case 7: {
                texture = menubarTexture;
            }
        }
        return texture;
    }

    public static void fillComponent(Graphics g2, Component c2, int textureType) {
        JTattooUtilities.fillComponent(g2, c2, TextureUtils.getTexture(textureType));
    }

    public static void fillComponent(Graphics g2, Component c2, int x, int y, int w, int h2, int textureType) {
        Graphics2D g2D = (Graphics2D)g2;
        Shape savedClip = g2D.getClip();
        Area clipArea = new Area(new Rectangle2D.Double(x, y, w, h2));
        if (savedClip != null) {
            clipArea.intersect(new Area(savedClip));
        }
        g2D.setClip(clipArea);
        Icon texture = TextureUtils.getTexture(textureType);
        if (texture != null) {
            int tw = texture.getIconWidth();
            int th = texture.getIconHeight();
            Point p = JTattooUtilities.getRelLocation(c2);
            for (int ys = y - p.y; ys < y + h2; ys += th) {
                for (int xs = x - p.x; xs < x + w; xs += tw) {
                    texture.paintIcon(c2, g2, xs, ys);
                }
            }
        } else {
            g2.setColor(c2.getBackground());
            g2.fillRect(x, y, w, h2);
        }
        g2D.setClip(savedClip);
    }

    public static void fillRect(Graphics g2, Component c2, int x, int y, int w, int h2, int textureType) {
        Graphics2D g2D = (Graphics2D)g2;
        Shape savedClip = g2D.getClip();
        Area clipArea = new Area(new Rectangle2D.Double(x, y, w, h2));
        if (savedClip != null) {
            clipArea.intersect(new Area(savedClip));
        }
        g2D.setClip(clipArea);
        Icon texture = TextureUtils.getTexture(textureType);
        if (texture != null) {
            int tw = texture.getIconWidth();
            int th = texture.getIconHeight();
            for (int ys = y; ys < y + h2; ys += th) {
                for (int xs = x; xs < x + w; xs += tw) {
                    texture.paintIcon(c2, g2, xs, ys);
                }
            }
        } else {
            g2.setColor(c2.getBackground());
            g2.fillRect(x, y, w, h2);
        }
        g2D.setClip(savedClip);
    }
}

